/* FILE: mpick.h                                (D. Tottingham  09/11/89)

This is an include file of defines, data structure definitions and
external declarations that are common in the mpick module.

*/

#ifndef _MPICK_
#define _MPICK_

/************************************************************************
                               INCLUDES

************************************************************************/
#include "mconst.h"
#include "mqueue.h"


/************************************************************************
                         EXTERNAL DECLARATIONS

These functions can be called from all modules that include this file.

************************************************************************/
PUBLIC Q_ARRIVAL far * pk_get_first_arrival ();
PUBLIC Q_MAGNITUDE far * pk_get_first_magnitude ();
PUBLIC Q_ARRIVAL far * pk_get_last_arrival ();
PUBLIC Q_MAGNITUDE far * pk_get_last_magnitude ();
PUBLIC Q_ARRIVAL far * pk_get_next_arrival ();
PUBLIC Q_MAGNITUDE far * pk_get_next_magnitude ();
PUBLIC unsigned int pk_get_narrivals ();
PUBLIC unsigned int pk_get_nmagnitudes ();
PUBLIC void pk_initialize ();
PUBLIC void pk_pick_arrivals ();
PUBLIC void pk_pick_magnitudes ();
PUBLIC void pk_reset_picks ();

#endif
